/* This file has been generated by Fred's Fisher Price record creator v2.1.0.0 on 14 Aug 2012 23:31
 * http://www.instructables.com/id/3D-printing-records-for-a-Fisher-Price-toy-record-/
 *
 * Press F6 to view your model in OpenSCAD
 * Then you cn export as STL for printing
 */

// Configuration
$fn = 100;
hStock = 3;
rStock = 60.58;
oDrive = 21.8;
rDrive = 1.55;
hInset = 1;
rInset = 25.6;
hGroove = 1.2;
overlap = 0.2;

hasSecondSide = 0;

// Some very useful code by HarlanDMii
// http://www.thingiverse.com/thing:16193
use <write.scad>

// Create disc
module createDisc() {
	union() {

		createBlank();

		// Add the notes for the song. This part is dynamically generated.
		// Autogenerated pins for music tracks
		pin(27.95,29.15,79.0772177007917,0);
		pin(27.95,29.15,200.231063854638,0);
		pin(29.15,30.35,6.51980732302467,0);
		pin(29.15,30.35,48.0582688614862,0);
		pin(29.15,30.35,127.673653476871,0);
		pin(29.15,30.35,169.212115015332,0);
		pin(29.15,30.35,238.442884246102,0);
		pin(30.69,31.89,283.65711699625,0);
		pin(30.69,31.89,297.503270842404,0);
		pin(31.89,33.09,6.84674693675603,0);
		pin(31.89,33.09,128.000593090602,0);
		pin(33.51,34.71,-3.34965095077944,0);
		pin(33.51,34.71,3.57342597229748,0);
		pin(33.51,34.71,100.496502895374,0);
		pin(33.51,34.71,117.804195203067,0);
		pin(33.51,34.71,124.727272126144,0);
		pin(33.51,34.71,211.265733664605,0);
		pin(33.51,34.71,221.650349049221,0);
		pin(33.51,34.71,232.034964433836,0);
		pin(33.51,34.71,283.958041356913,0);
		pin(33.51,34.71,290.88111827999,0);
		pin(33.51,34.71,332.419579818451,0);
		pin(34.71,35.91,27.8993287148753,0);
		pin(34.71,35.91,59.0531748687214,0);
		pin(34.71,35.91,90.2070210225676,0);
		pin(34.71,35.91,149.053174868721,0);
		pin(34.71,35.91,180.207021022568,0);
		pin(34.71,35.91,239.053174868721,0);
		pin(34.71,35.91,245.976251791798,0);
		pin(34.71,35.91,249.437790253337,0);
		pin(34.71,35.91,263.283944099491,0);
		pin(34.71,35.91,280.591636407183,0);
		pin(34.71,35.91,297.899328714875,0);
		pin(34.71,35.91,304.822405637952,0);
		pin(34.71,35.91,308.283944099491,0);
		pin(36.225,37.425,100.742794089183,0);
		pin(36.225,37.425,221.896640243029,0);
		pin(36.225,37.425,284.204332550721,0);
		pin(36.225,37.425,332.665871012259,0);
		pin(37.425,38.625,7.36308449401117,0);
		pin(37.425,38.625,28.1323152632419,0);
		pin(37.425,38.625,59.2861614170881,0);
		pin(37.425,38.625,128.516930647857,0);
		pin(37.425,38.625,149.286161417088,0);
		pin(37.425,38.625,170.055392186319,0);
		pin(37.425,38.625,201.209238340165,0);
		pin(37.425,38.625,260.055392186319,0);
		pin(37.425,38.625,308.516930647857,0);
		pin(39.025,40.225,17.8846100259667,0);
		pin(39.025,40.225,49.0384561798129,0);
		pin(39.025,40.225,80.192302333659,0);
		pin(39.025,40.225,139.038456179813,0);
		pin(39.025,40.225,159.807686949044,0);
		pin(39.025,40.225,180.576917718274,0);
		pin(39.025,40.225,249.807686949044,0);
		pin(39.025,40.225,263.653840795197,0);
		pin(39.025,40.225,319.038456179813,0);
		pin(40.225,41.425,35.2631340277846,0);
		pin(40.225,41.425,90.6477494124,0);
		pin(40.225,41.425,156.416980181631,0);
		pin(40.225,41.425,211.801595566246,0);
		pin(40.225,41.425,256.801595566246,0);
		pin(40.225,41.425,274.109287873938,0);
		pin(40.225,41.425,329.493903258554,0);
		pin(41.8,43,66.534497253683,0);
		pin(41.8,43,101.149881869068,0);
		pin(41.8,43,187.688343407529,0);
		pin(41.8,43,222.303728022914,0);
		pin(41.8,43,267.303728022914,0);
		pin(41.8,43,315.765266484452,0);
		pin(41.8,43,333.072958792145,0);
		pin(43,44.2,18.1349420559856,0);
		pin(43,44.2,38.9041728252164,0);
		pin(43,44.2,63.1349420559856,0);
		pin(43,44.2,80.4426343636779,0);
		pin(43,44.2,139.288788209832,0);
		pin(43,44.2,160.058018979063,0);
		pin(43,44.2,184.288788209832,0);
		pin(43,44.2,201.596480517524,0);
		pin(43,44.2,253.519557440601,0);
		pin(43,44.2,312.365711286755,0);
		pin(44.625,45.825,32.0871648905933,0);
		pin(44.625,45.825,49.3948571982856,0);
		pin(44.625,45.825,70.1640879675164,0);
		pin(44.625,45.825,94.3948571982856,0);
		pin(44.625,45.825,153.241011044439,0);
		pin(44.625,45.825,170.548703352132,0);
		pin(44.625,45.825,191.317934121363,0);
		pin(44.625,45.825,215.548703352132,0);
		pin(44.625,45.825,270.933318736747,0);
		pin(45.825,47.025,28.6802021381707,0);
		pin(45.825,47.025,90.987894445863,0);
		pin(45.825,47.025,149.834048292017,0);
		pin(45.825,47.025,212.141740599709,0);
		pin(45.825,47.025,250.218663676632,0);
		pin(47.355,48.555,59.9231005060865,0);
		pin(47.355,48.555,98.0000235830096,0);
		pin(47.355,48.555,181.076946659933,0);
		pin(47.355,48.555,219.153869736856,0);
		pin(47.355,48.555,309.153869736856,0);
		pin(48.555,49.755,18.433249543542,0);
		pin(48.555,49.755,49.5870956973881,0);
		pin(48.555,49.755,80.7409418512343,0);
		pin(48.555,49.755,170.740941851234,0);
		pin(48.555,49.755,201.89478800508,0);
		pin(50.115,51.315,39.2833880557071,0);
		pin(50.115,51.315,70.4372342095533,0);
		pin(50.115,51.315,139.668003440323,0);
		pin(50.115,51.315,191.591080363399,0);
		pin(50.115,51.315,323.129541901861,0);
		pin(51.315,52.515,160.480755843882,0);
		pin(55.7,56.9,39.5066963075012,0);
		pin(55.7,56.9,70.6605424613473,0);
		pin(55.7,56.9,191.814388615193,0);

		title("STAR WARS",0);


	}
}

// Create the blank, ready for dynamically added pins
module createBlank() {

	difference() {
	
		// stock
		cylinder(h=hStock, r=rStock);
	
		// top cutout
		translate(v = [0,0,hStock-hInset+overlap]) {
			cylinder(h=hInset + overlap, r=rInset);
		}

		// Bottom cutout lets the disc sit flatter, but some printers my struggle with the overhang
		translate(v = [0,0,-overlap]) {
			cylinder(h=hInset + overlap, r=rInset);
		}
		
		// Centre hole
		cylinder(h=hStock, r=3.22);

		// Drive holes
		translate(v = [0,oDrive,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [0,-oDrive,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [oDrive,0,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [-oDrive,0,0]) { cylinder(h=hStock, r=rDrive); }

		// Tracks - each one for two notes
		track(28.15, 0);
		track(30.89, 0);
		track(33.71, 0);
		track(36.425, 0);
		track(39.225, 0);
		track(42, 0);
		track(44.825, 0);
		track(47.555, 0);
		track(50.315, 0);
		track(53.11, 0);
		track(55.9, 0);

		if (hasSecondSide > 0) {
			track(28.15, 1);
			track(30.89, 1);
			track(33.71, 1);
			track(36.425, 1);
			track(39.225, 1);
			track(42, 1);
			track(44.825, 1);
			track(47.555, 1);
			track(50.315, 1);
			track(53.11, 1);
			track(55.9, 1);
		}
	}
}

// Negative for a double track
module track(inner, onSecondSide) {
	if (onSecondSide > 0) {
		translate(v = [0,0,-overlap]) {
			difference() {
				cylinder(h=hGroove+overlap, r=inner+2);
				cylinder(h=hGroove+overlap, r=inner);
			}
		}
	}
	else {
		translate(v = [0,0,hStock-hGroove]) {
			difference() {
				cylinder(h=hGroove+overlap, r=inner+2);
				cylinder(h=hGroove+overlap, r=inner);
			}
		}
	}

}

// Create a pin at a certain angle
module pin(inner, outer, angle, onSecondSide)
{
	rotate(a=angle) {
		if (onSecondSide > 0) {
			translate(v=[inner, -0.5, - overlap]) {
				# cube (size=[outer-inner, 1 ,hGroove + overlap], center=false);
			}
		} else {
			translate(v=[inner, -0.5, hStock - hGroove - overlap]) {
				# cube (size=[outer-inner, 1 ,hGroove + overlap], center=false);
			}
		}
	}
}

// Add text
module title(text, onSecondSide)
{
	if (onSecondSide>0)
		writecylinder(text, [0,0,-hInset], radius=20, height=hStock-hInset, h=3, t=hInset, face="bottom");
	else
		writecylinder(text, [0,0,0], radius=20, height=hStock-hInset, h=3, t=hInset, face="top");
}

// Do the work
createDisc();
